/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.item;

import java.util.Locale;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.tools.entity.EntityModArrow;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ItemModArrow
extends ItemArrow {
    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ArrowType.fromMeta(stack.func_77960_j()).getName();
    }

    public EntityArrow func_185052_a(World world, ItemStack stack, EntityLivingBase shooter) {
        return new EntityModArrow(world, shooter, stack.func_77960_j());
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, EntityPlayer player) {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (ArrowType type : ArrowType.values()) {
                if (!type.isEnabled()) continue;
                items.add((Object)new ItemStack((Item)this, 1, type.getMeta()));
            }
        }
    }

    public static enum ArrowType {
        CHARGED(() -> Config.enableChargedArrow);

        private int meta = this.ordinal();
        private BooleanSupplier enabled;

        private ArrowType(BooleanSupplier enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled.getAsBoolean();
        }

        public int getMeta() {
            return this.meta;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.US);
        }

        public static ArrowType fromMeta(int meta) {
            if (meta >= ArrowType.values().length) {
                meta = 0;
            }
            return ArrowType.values()[meta];
        }
    }
}

